// HPR Control messages (same as that of Application)
// HPR Control messages
#define HPRF_CTRL_MSG_ACQUIRE_SUCCESS       1
#define HPRF_CTRL_MSG_ACQUIRE_TIMEOUT       2
#define HPRF_CTRL_MSG_ACQUIRE_FAIL          3
#define HPRF_CTRL_MSG_GW_CONNECTED          4
#define HPRF_CTRL_MSG_GW_DISCONNECTED       5
#define HPRF_CTRL_MSG_CTRL_SYS_CONNECTED    6
#define HPRF_CTRL_MSG_CTRL_SYS_DISCONNECTED 7
#define HPRF_CTRL_MSG_LQI_DATA              8

/////////////////////////////////////////////////////////////////////////////////
///// Structures for system error logs
// Use this macro to disable Error messages logging for windows CE case.
// A 2K memory is used. In TPS-6X case we had error logging mechanism.
// Log to this buffer and later app can read it using console command
#define HPRF_ERR_MSG_LOG
#define HPRF_ERR_MSG_LOG_BUF_SIZE   2048

typedef struct
{
    CHAR RFErrorMsgBuff[HPRF_ERR_MSG_LOG_BUF_SIZE];
    UINT32 NoErrorMsgs;
    UINT32 TotalBytes;
}TYPE_RF_ERR_LOG;
extern TYPE_RF_ERR_LOG RfErrorLog;

/////////////////////////////////////////////////////////////////////////////////
// Control code and structures required for the RF diagnostics.
#define HPR_DIAG_CTRL_NONE              0
#define HPR_DIAG_CTRL_SHOW_DIAG_INFO    1
#define HPR_DIAG_CTRL_PHY_INFO          2
#define HPR_DIAG_CTRL_DESCR             3
#define HPR_DIAG_CTRL_RF_STACK_TRACE    4
#define HPR_DIAG_CTRL_RF_STACK_DIAG     5
#define HPR_DIAG_CTRL_RF_CLR_DIAG       6
#define HPR_DIAG_CTRL_RF_PHY_READ       7
#define HPR_DIAG_CTRL_RF_ERR_LOG        8
#define HPR_DIAG_CTRL_RF_NETLINK        9
#define HPR_DIAG_CTRL_RF_VERSION        10
#define HPR_DIAG_CTRL_RF_POWER_DBM      11

// Structure to receive the control code from application
// for the diag
typedef struct
{
    DWORD dwCode;
}RF_DIAG_CTRL;

// PHY information
typedef struct
{
    DWORD PhyInitFailed;
    DWORD PhyChipId;
}RF_PHY_INFO;

// Structure for diag
typedef struct
{
    DWORD Rfdiags_numTimer1Ints;
    DWORD Rfdiags_numLOUnLockInts;
    DWORD Rfdiags_numInvalidPhyPacketsRecvd;
    DWORD Rfdiags_numCCA_TxDone;
    DWORD Rfdiags_LowLevelRecvCnt;
    DWORD Rfdiags_LowLevelRecvByteCnt;
    DWORD Rfdiags_LowLevelTotalLostPackets;
    DWORD Rfdiags_LowLevelInvalidRxPacketCnt;
    DWORD Rfdiags_LowLevelRetryPacketCnt;
    DWORD Rfdiags_LowLevelTxPacketCnt;
    DWORD Rfdiags_LowLevelTxPacketBytes;
    DWORD Rfdiags_LowLevelResets;
    DWORD Rfdiags_numBadTimerISR;
    DWORD Rfdiags_ChannelBusyResets;
    DWORD Rfdiags_NumDataConfMessages;
    DWORD Rfdiags_NumResetAndNacks;
    DWORD Rfdiags_Congestion;
    DWORD Rfdiags_Utilization;
    DWORD Rfdiags_NumCCAFailures;
    DWORD Rfdiags_NumCCATimeoutsFailures;
    DWORD Rfdiags_NumRxInactivityResets;
}RF_DIAG;

// Strcture for HPR_DIAG_SHOW_LINK_INFO
typedef struct
{
    DWORD linkstatecnt;
    DWORD linkqualityAtLocalDevice;
    DWORD txpacketcount;
    DWORD txpacketretrycount;
    DWORD rxpacketcount;
    DWORD rxpacketrepeatcount;
    DWORD rxpacketsequenceErrcount;
    DWORD rxpacketsegmentationerrcnt;
    RF_DIAG rfdiag;
    RF_PHY_INFO PhyInfo;
}RF_DIAG_SHOW_DIAG_INFO;

// Strcture (input) for HPR_DIAG_CTRL_DESCR
typedef struct
{
    RF_DIAG_CTRL DiagCtrl;
    DWORD index;
}RF_DIAG_DESCR;

// Structure to return the RF stack trace
#define SMAC_SM_DEBUG_NUMENTRIES    (10*1024)
typedef struct
{
    UINT16 SMAC_SM_Debug_State[SMAC_SM_DEBUG_NUMENTRIES];
    UINT32 SMAC_SM_Debug_Timestamp[SMAC_SM_DEBUG_NUMENTRIES];
    UINT32 SMAC_SM_Debug_State_Ctr;
}TYPE_RF_STACK_TRACE;

// Structure for RFSTACKDIAG (HPR_DIAG_CTRL_RF_STACK_DIAG)
typedef struct
{
    RF_DIAG rfdiag;
    DWORD numResCodeTimeouts;
    DWORD errpktcnt;
}TYPE_RF_STACK_DIAG;

// Structure for RFPHYREAD (HPR_DIAG_CTRL_RF_PHY_READ)
#define MC1319xDRV_MAX_REGS 0x32
typedef struct
{
    RF_DIAG_CTRL DiagCtrl;
    DWORD ReadAddr;
    DWORD ReadCount;
    DWORD Data[MC1319xDRV_MAX_REGS];
}TYPE_RF_PHY_READ;

// Structure for Error logs
typedef struct
{
    RF_DIAG_CTRL DiagCtrl;
    DWORD Control;          // 0 = Read, 1 = clear log
}TYPE_RF_DIAG_ERR_LOG;

// RF Netlink information
typedef struct
{
    DWORD GwConn;           // 1 = connected, 0 = disconnected
    DWORD CtrlSysConn;      // 1 = connected, 0 = disconnected
    DWORD GwCtrlConnType;   // 0 = no connection, 1 = cresnet, 2 = ethernet
    DWORD GwCnetId;         // Gateway cresnet Id
    CHAR  LinkStateStr[64]; // LinkState string
    CHAR  TimeStr[64];      // Link Duration string
    DWORD LinkCount;
    float RxLQIinDev;       // Rec LQI in device (percent).
    float RxLQIinGW;        // Rec LQI in GW (percent)
}TYPE_RF_NETLINK_INFO;

// RF Version
typedef struct
{
    CHAR  RFVersion[64];
    CHAR  SmacVersion[64];
}TYPE_RF_VERSION_INFO;

// HPR_DIAG_CTRL_RF_POWER_DBM (power level in dBm based on channel and power hi lo)
typedef struct
{
    RF_DIAG_CTRL DiagCtrl;
    DWORD Power;
    DWORD Translate;
    FLOAT Power_dBm;
}TYPE_RF_POWER_DBM;

/////////////////////////////////////////////////////////////////////////////////
// Control code and structures required for the RF tests.
#define HPR_TEST_CTRL_NONE               0
#define HPR_TEST_CTRL_TELEC_TEST         1
#define HPR_TEST_CTRL_ECHO_TEST          2
#define HPR_TEST_CTRL_STACK_RESET        3

// Structure to receive the control code from application
// for the tests
typedef struct
{
    DWORD dwCode;
}RF_TEST_CTRL;

// Telec Test Information
typedef struct
{
    RF_TEST_CTRL TestCtrl;
    DWORD dwMode;
    DWORD dwChannel;
    DWORD dwPower;
}RF_TEST_TELEC_DATA;

// Echo Test Information
typedef struct
{
    RF_TEST_CTRL TestCtrl;
    DWORD dwRFId;
    DWORD dwRepeat;
    CHAR bDataBuffer[128];
    DWORD dwDataLen;

}RF_TEST_ECHO_TEST_DATA;

/////////////////////////////////////////////////////////////////////////////////
// Control code and structures for the diagnostics and test responses
// to be sent using the diagnostics queue to the application
#define HPRF_DIAG_DATA_NONE                     0
#define HPRF_DIAG_DATA_ECHO_TEST_REPLY          1
#define HPRF_DIAG_DATA_DESCR_COMMAND_REPLY      2
#define HPRF_DIAG_DATA_CONSOLE_PRINT            3

typedef	struct	{
	UINT32	repeatno;						
	UINT32	invalidresponses;
	UINT32	noresponses;
	UINT8	localrxlqi;						
	UINT8	remoterxlqi;						
	UINT32	avgrxlqi;					
	UINT32	avgremotedevicerxlqi;
	UINT32	tick;	
	UINT32	txpacketcount;
	UINT32	txpacketpayloadbytecount;
	UINT32	rxpacketcount;
	UINT32	rxpacketpayloadbytecount;	

	BOOL	done;							//	TRUE=if tests are complete
}	TYPE_RF_DIAG_ECHO_REPLY_PACKET;	
// Structure to return the diag data for DESCR command
typedef struct
{
    CHAR Buffer[128];
    DWORD dwStrLen;
}TYPE_RF_DIAG_DATA_DESCR_REPLY;


// Structure to send console printfs to application
// Make sure the total length of the HPR_TY_DiagData is note more
// than the Queue message size (260)
typedef struct
{
    CHAR buffer[240];
    DWORD dwStrLen;
}TYPE_RF_DIAG_CONSOLE_DATA;


// Test and diagnostics response structure generic.
typedef struct
{
    DWORD dwDataCode;
    union
    {
        TYPE_RF_DIAG_ECHO_REPLY_PACKET EchoReply;
        TYPE_RF_DIAG_DATA_DESCR_REPLY DescReply;
        TYPE_RF_DIAG_CONSOLE_DATA Console;
                                                // << Add new packet types here
    }Data;
}HPR_TY_DiagData;